//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : ADC.h
// Description: ADC滖
//Targer Board: None
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________


#ifndef _ADC_H_
#define _ADC_H_


extern	u16	gu16v_pressure_output;
extern	u16	gu16v_pressure_output_old;
extern	u16	gu16v_scf_buff[8];
#define	LU8C_scf_buff_out	4
extern	u16	gu16v_scf_buff_out[LU8C_scf_buff_out];

extern	u16	gu16v_scf_output_xbuff[3];
extern	u16	gu16v_scf_output_ybuff[3];
extern	u16	gu16v_pressure_output_xbuff[2];
extern	u16	gu16v_pressure_output_ybuff[2];
extern	__16_type	gu16v_old_pressure;
extern	__16_type	gu16v_current_pressure;
extern	__16_type	gu16v_cal_300mmhg;
extern	__16_type	gu16v_cal_0mmhg;
extern	__16_type	gu16v_zero;
extern	u8	gu8v_battery_votage;
extern	u8	gu8a_heart_wave_data;
extern	u16	gu8a_heart_wave_data_TEST;
extern	u16	gu8a_PRESSURE_data_TEST;


extern	u8	gu8a_heart_wave_data_uart;
extern	u16	gu16v_pressure_uart;


u16 fun_Get_ADC(u8 lu8c_adc_channel);
u16 fun_Get_ADC_Key(u8 lu8c_adc_channel);
void fun_iir_filter(u16 lu16_current_adc_data);
void fun_iir_filter1(u16 lu16_current_adc_data);
void fun_Disable_ADC();
void fun_Enable_ADC();
void TEST_ADC();  
//                           @--------------_adcr---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name | START  | EOCB   | ADOFF  |  〞     |IDLE_CONV| ACS2  | ACS1   | ACS0   |
// |______________________________________________________________________________
// | POR  |   0    |   1    |   1    |  〞     |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 7 STARTㄩ
// Bit 6 EOCBㄩ
// Bit 5 ADOFFㄩ
// Bit 4  帤隅砱
// Bit 3 IDLE_CONVㄩ
// Bit 2~0 ACS2~ACS0ㄩ
// 	000ㄩAN0 (PB0)	001ㄩAN1 (PB1) 010ㄩAN2 (PB2) 011ㄩAN3 (PB3) 
// 	100ㄩAN4 (PGA2) 101ㄩAN5 (SCF PGA) 110ㄩAN6 (PGA1) 111ㄩAN7 (battery)
#define ADCR_Default		0b01000000   // AN0
#define AN0		0		//
#define AN1		1		//
#define AN2		2		//
#define AN3		3		//
#define AN4		4		//
#define AN5		5		//
#define AN6		6		//
#define AN7		7		//

//                           @--------------_acsr---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |  〞     |  〞     |  〞     |  VREFS |  ACCM  | ADCK2  | ADCK1  | ADCK0  |
// |______________________________________________________________________________
// | POR  |   0    |   1    |   1    |  〞     |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 7~5 
// Bit 4 VREFS
// 	0ㄩAVDD
// 	1ㄩVREF 
// Bit 3  ACCM
// Bit 2~0 ADCK2~ADCK0ㄩ
// 	000ㄩfSYS/2
// 	001ㄩfSYS/8
// 	010ㄩfSYS/32
// 	011ㄩUD
// 	100ㄩfSYS
// 	101ㄩfSYS/4
// 	110ㄩfSYS/64
// 	111ㄩUD
#define ACSR_Default		0b00001001   // 8MHZ/8 = 1US >0.5US


//                           @--------------_acsr---------------@
//  ______________________________________________________________________________
// | Bit  |  Bit7  |  Bit6  |  Bit5  |  Bit4  |  Bit3  |  Bit2  |  Bit1  |  Bit0  |
//  ______________________________________________________________________________
// | Name |  〞     |  〞     |  〞     |  〞     |  PCR3  | PCR2   | PCR1   | PCR0   |
// |______________________________________________________________________________
// | POR  |   0    |   1    |   1    |  〞     |   0    |   0    |   0    |   0    |
// |_______________________________________________________________________________
// Bit 7~4  
// Bit 3 PCR3ㄩPB3 A/D
// 	0ㄩN
// 	1ㄩY
// Bit 2 PCR2ㄩPB2 A/D
// 	0ㄩN
// 	1ㄩY
// Bit 1 PCR1ㄩPB1 A/D
// 	0ㄩN
// 	1ㄩY
// Bit 0 PCR0ㄩPB0 A/D
// 	0ㄩN
// 	1ㄩY AN0 OR VREF
#define ANCSR_Default	0B00000000;		//蘇庲偞离IO






#endif

